package cn.com.duiba.cloud.thirdparty.channel.server.api.remoteservice.wechat;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.thirdparty.channel.server.api.dto.WechatAuthorizerStatusDTO;
import cn.com.duiba.cloud.thirdparty.channel.server.api.param.AuthorizerInfoParam;
import cn.com.duiba.cloud.thirdparty.channel.server.api.param.WechatAuthorizerQueryParam;

/**
 * 微信授权相关服务
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/6/13 10:43 上午
 **/
@AdvancedFeignClient
public interface RemoteWechatAuthorizerService {
    /**
     * 获取授权url
     *
     * @param authType 1则商户扫码后，手机端仅展示公众号、2表示仅展示小程序，3表示公众号和小程序都展示。
     * @return
     * @throws BizException
     */
    String getAuthorizationUrl(Integer authType) throws BizException;

    /**
     * 保存授权信息
     *
     * @param param
     * @throws BizException
     */
    String saveAuthorizerInfo(AuthorizerInfoParam param) throws BizException;

    /**
     * 获取授权状态
     *
     * @param param
     * @return
     */
    WechatAuthorizerStatusDTO getAuthorizerStatus(WechatAuthorizerQueryParam param) ;
}
