/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.handler;

import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretAnnotation;
import cn.com.duiba.cloud.manage.service.api.annotation.DataSecretFiledAnnotation;
import cn.com.duiba.cloud.manage.service.api.config.SecretProperties;
import cn.com.duiba.cloud.manage.service.api.model.enums.AlgorithmEnum;
import cn.com.duiba.cloud.manage.service.api.utils.AESCBCUtil;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
public class DataSecretHandler
extends RequestBodyAdviceAdapter {
    public static final String DATA_SECRET_ANNOTATION = "DATA_SECRET_ANNOTATION";
    @Resource
    private SecretProperties secretProperties;

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = sra.getRequest();
        DataSecretAnnotation dataMaskingAnnotation = (DataSecretAnnotation)request.getAttribute(DATA_SECRET_ANNOTATION);
        return dataMaskingAnnotation != null;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        if (Objects.isNull(this.secretProperties.getKey())) {
            return body;
        }
        if (Objects.isNull(body)) {
            return body;
        }
        Stream.of(body.getClass().getDeclaredFields()).forEach(field -> {
            if (field.isAnnotationPresent(DataSecretFiledAnnotation.class)) {
                AlgorithmEnum algorithmEnum = field.getAnnotation(DataSecretFiledAnnotation.class).value();
                try {
                    field.setAccessible(true);
                    switch (algorithmEnum) {
                        case AES: {
                            field.set(body, AESCBCUtil.decrypt(String.valueOf(field.get(body)), this.secretProperties.getKey()));
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
        return body;
    }
}

