package cn.com.duiba.cloud.manage.service.api.model.dto.tenant;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/5 11:51
 */
@Getter
@Setter
@ToString
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TenantDbDTO implements Serializable {

    private static final long serialVersionUID = -4793101041305969918L;
    /**
     *
     */
    private Long id;
    /**
     * 租户名称
     */
    private String name;
    /**
     * 租户号，全局唯一
     */
    private String tenantNo;
    /**
     * 所属行业id
     */
    private Long industryId;
    /**
     * 租户key
     */
    private String tenantKey;
    /**
     * 租户密钥
     */
    private String tenantSecret;
    /**
     * 备注
     */
    private String remark;
    /**
     * 企业类型
     */
    private String tenantType;
    /**
     * 租户状态 0-不可用 1-可用
     */
    private Integer state;
    /**
     * 用户自定义logo标记
     */
    private String logo;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    /**
     * 租户创建者
     */
    private Long createdBy;
    /**
     * 修改人
     */
    private Long modifiedBy;
}
