package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppSimpleDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.TenantDbDTO;

import java.util.List;

/**
 * 租户应用服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/7
 */
@AdvancedFeignClient
public interface RemoteTenantAppService {

    /**
     * 通过租户应用id查询应用信息
     * 兼容 -> 参数无用
     *
     * @param tenantAppId
     * @return
     * @throws BizException
     */
    TenantAppSimpleDTO getInfoByTenantAppId(Long tenantAppId) throws BizException;

    /**
     * 按照ID获取List集合
     * 兼容 -> 参数无用
     *
     * @param idList
     * @return
     * @throws BizException
     */
    List<TenantAppDTO> selectListByIdList(List<Long> idList) throws BizException;

    /**
     * 通过id查询详情
     * 参数可不穿
     *
     * @param id 租户应用id
     * @return 详情
     * @throws BizException 业务异常
     */
    TenantAppDTO detail(Long id) throws BizException;

}
