package cn.com.duiba.cloud.manage.service.api.model.enums;

import cn.hutool.core.util.StrUtil;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description redis key
 * @date 2021/11/8 11:20
 */
public enum RedisKeyEnum {

    /* 权益相关 */
    TENANT_RIGHTS_CACHE("租户权益缓存", "DUIBA_MANAGE_SERVICE:TENANT_RIGHTS:{}"),

    /**
     * 租户相关
     */
    FIRST_LOGIN("首次登录", "DUIBA_MANAGE_SERVICE:FIRST_LOGIN"),
    CAPTCHA("图片验证码", "DUIBA_MANAGE_SERVICE:CAPTCHA"),
    LAST_LOGIN("上次登录", "DUIBA_MANAGE_SERVICE:LAST_LOGIN"),
    TENANT_STAFF_REL("租户内员工关系", "DUIBA_MANAGE_SERVICE:TENANT_STAFF_REL:{}_{}"),

    /* 角色相关 */

    UNIQUE_TENANT_APP_ROLE_NAME("租户下角色名称唯一", "DUIBA_MANAGE_SERVICE:TB_ROLE:{}_{}_{}"),
    UNIQUE_TENANT_NAME("租户名称唯一", "DUIBA_MANAGE_SERVICE:TB_TENANT:{}"),
    UNIQUE_DEPT_NAME("部门名称唯一", "DUIBA_MANAGE_SERVICE:TB_DEPT:{}"),
    UNIQUE_RS_TENANT_ADD("添加关联租户锁", "DUIBA_MANAGE_SERVICE:TB_RS_TENANT:{tenantId}_{tenantIdTo}"),
    UNIQUE_RS_TENANT_UPDATE_STATE("修改关联租户状态锁", "DUIBA_MANAGE_SERVICE:TB_RS_TENANT:{tenantId}_{id}"),

    /* 应用相关 */
    UNIQUE_APP_CREATE("应用创建唯一", "DUIBA_MANAGE_SERVICE:TB_RS_TENANT_APP:{}_{}",
            "租户id tenantId", "应用id appId")

    ;

    private final String template;
    private final String desc;
    private final String[] argsDesc;

    RedisKeyEnum(String desc, String template, String...argsDesc) {
        this.template = template;
        this.desc = desc;
        this.argsDesc = argsDesc;
    }

    public static String getRedisKey(RedisKeyEnum keyTemplate, Object... args) {
        return StrUtil.format(keyTemplate.template, args);
    }

    public String getTemplate() {
        return template;
    }
}
