package cn.com.duiba.cloud.manage.service.api.model.param.tenant;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * tb_rs_tenant
 *
 * @author
 */
@Getter
@Setter
public class RsTenantRequest extends BaseParam {
    private static final long serialVersionUID = 1L;
    private Long id;
    /**
     * 接收邀请的租户ID
     */
    private Long tenantIdTo;
    /**
     * 状态 0-发起邀请 1-同意邀请 2-拒绝邀请
     *
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.tenant.RsTenantStateEnum
     */
    private Integer state;
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;
    private Long createdBy;
    private Long modifiedBy;
    /**
     * 邀请类型 1：供应关系
     *
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.tenant.RsTenantTypeEnum
     */
    private Integer rsType;
    /**
     * 是否审核商品
     *
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.tenant.RsTenantCheckGoodsEnum
     */
    private Integer checkGoods;

    /**
     * 关联的应用Id
     */
    private Long rsAppId;
}