package cn.com.duiba.cloud.manage.service.api.remoteservice.audit;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.audit.AuditDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteOptListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteOptParam;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteQueryByBizNoParam;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteRevokeListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteRevokeParam;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteSubmitListParam;
import cn.com.duiba.cloud.manage.service.api.model.param.audit.RemoteSubmitParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
* 审核表 RemoteService
* @author xiaotian
* 2021-11-4 14:39:19
*/
@AdvancedFeignClient
public interface RemoteAuditService {

    /**
     * 审核提交
     * @param remoSubmitParam
     * @return
     */
    AuditDTO auditSubmit(RemoteSubmitParam remoSubmitParam) throws BizException;

    /**
     * 批量审核提交
     * @param remoteSubmitListParam
     * @return
     */
    List<AuditDTO> auditSubmitList(RemoteSubmitListParam remoteSubmitListParam) throws BizException;
    /**
     * 撤销审核
     * @param remoteRevokeParam
     * @return
     * @throws BizException
     */
    AuditDTO auditRevoke(RemoteRevokeParam remoteRevokeParam) throws BizException;

    /**
     * 批量撤销审核
     * @param remoteRevokeListParam
     * @return
     * @throws BizException
     */
    List<AuditDTO> auditRevokeList(RemoteRevokeListParam remoteRevokeListParam) throws BizException;

    /**
     * 查询审批列表
     * @param remoteQueryParam
     * @return
     */
    PageResponse<AuditDTO> pageQuery(RemoteQueryParam remoteQueryParam);

    /**
     * 按业务单号查询审核流水
     * @param remoteQueryByBizNoParam
     * @return
     */
    PageResponse<AuditDTO> queryByBizNo(RemoteQueryByBizNoParam remoteQueryByBizNoParam);

    /**
     * 审核操作
     * @param remoteOptParam
     * @return
     */
    Integer auditOpt(RemoteOptParam remoteOptParam) throws BizException;

    /**
     * 批量审核操作
     * @param remoteOptListParam
     * @return
     */
    Integer auditOptList(RemoteOptListParam remoteOptListParam) throws BizException;


    /**
     * 获取最新审核信息-主要是审核状态
     * @param remoteQueryByBizNoParam
     * @return
     */
    AuditDTO selectOneByBizNo(RemoteQueryByBizNoParam remoteQueryByBizNoParam);

    /**
     * 获取审核流水
     * @param remoteQueryByBizNoParam
     * @return
     */
    List<AuditDTO> selectByBizNo(RemoteQueryByBizNoParam remoteQueryByBizNoParam);
}
