package cn.com.duiba.cloud.manage.service.api.model.dto.staff;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/11/29 18:29
 */
@Getter
@Setter
@ToString
public class TenantStaffDTO implements Serializable {

    private static final long serialVersionUID = 2390647116437246197L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 内部用户id
     */
    private Long innerUserId;
    /**
     * 用户id，可由租户设置，在当前租户下唯一
     */
    private String userId;
    /**
     * 租户id
     */
    private Long tenantId;
    /**
     * 员工名称
     */
    private String staffName;
    /**
     * 员工邮箱
     */
    private String email;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态 0-停用 1-启用
     */
    private Integer state;
    /**
     * 身份 0-租户管理员 1-普通用户
     */
    private Integer identify;
    /**
     * 岗位名称
     */
    private String positionName;
}
