package cn.com.duiba.cloud.manage.service.api.model.param.exportrecord;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;


/**
 * 导出记录查询
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/11/22 4:28 下午
 **/
@Getter
@Setter
public class RemoteExportRecordQueryParam extends PageRequest {

    private static final long serialVersionUID = 6514533720518419842L;

    /**
     * 操作的租户id
     */
    private Long tenantId;

    /**
     * 导出类型
     *
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.exportrecord.ExportDataTypeEnum
     */
    private Integer exportType;

    /**
     * 状态
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.exportrecord.ExportStateEnum
     */
    private Integer state;

    /**
     * 操作的租户应用id
     */
    private Long appId;

    /**
     * 用户id
     */
    private Long innerUserId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;
}
