package cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 插入短链任务请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 10:29
 * @since 0.0.7
 **/
@Data
@Accessors(chain = true)
public class RemoteSaveShortLinkTaskParam implements Serializable {
    private static final long serialVersionUID = -8783699611682016433L;

    /**
     * 任务备注
     */
    @NotNull(message = "任务备注不能为空")
    private String taskRemark;

    /**
     * 导入文件地址
     */
    @NotBlank(message = "导入文件地址不能为空")
    private String importFileUrl;

    /**
     * 创建人sso_id
     */
    @NotNull(message = "创建人不能为空")
    private Long createBy;
}
