package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.constant.autologin.AutoLoginConstant;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.autologin.DecryptDataParam;
import cn.com.duiba.cloud.manage.service.api.remoteservice.autologin.RemoteAutoLoginService;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.Cookie;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * 免登工具类
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2022/3/22 3:42 下午
 **/
@Slf4j
public class AutoLoginUtil {
    /**
     * 获取当前用户信息
     * 注意点：
     * 1、用户信息获取失败会返回null，接入方更具情况对外抛出异常
     * 2、有可能会出现窜数据情况（相同浏览器，appA留下的数据，appB来），接入方需要对appId进行判断
     *
     * @return
     * @throws BizException
     */
    public static ConsumerCookieDTO getConsumerInfo() {
        String timestamp = "";
        String encodeConsumerData = "";
        // 获取cookie中的数据
        Cookie[] cookies = CookieUtil.getCookies();
        if (cookies == null || cookies.length == 0) {
            log.warn("[用户信息] 用户信息获取失败，无cookie");
            return null;
        }
        for (Cookie cookie : cookies) {
            if (AutoLoginConstant.CookieName.LOGIN_TIME_COOKIE.equals(cookie.getName())) {
                timestamp = cookie.getValue();
            } else if (AutoLoginConstant.CookieName.LOGIN_CONSUMER_COOKIE.equals(cookie.getName())) {
                encodeConsumerData = cookie.getValue();
            }
        }

        if (StringUtils.isBlank(timestamp) || StringUtils.isBlank(encodeConsumerData)) {
            log.warn("[用户信息] 用户信息获取失败，cookie缺失");
            return null;
        }

        // 解密数据
        try {
            RemoteAutoLoginService remoteAutoLoginService = SpringUtil.getApplicationContext().getBean(RemoteAutoLoginService.class);
            DecryptDataParam decryptDataParam = DecryptDataParam.builder().data(encodeConsumerData).timestamp(Long.valueOf(timestamp)).build();
            String dataJson = remoteAutoLoginService.cookieDataDecrypt(decryptDataParam);
            return JSON.parseObject(dataJson, ConsumerCookieDTO.class);
        } catch (Exception e) {
            log.error("用户信息获取失败,可能登陆信息已过期或者假数据", e);
            return null;
        }
    }

    /**
     * 获取Transfer信息
     *
     * @return
     */
    public static String getTransfer() {
        return CookieUtil.getCookieValue(AutoLoginConstant.CookieName.TRANSFER);
    }

    /**
     * 获取dcustom信息
     *
     * @return
     * @throws UnsupportedEncodingException
     */
    public static String getDCustom() throws UnsupportedEncodingException {
        String dCustomValue = CookieUtil.getCookieValue(AutoLoginConstant.CookieName.DCUSTOM);
        if (StringUtils.isBlank(dCustomValue)) {
            return null;
        }
        return URLDecoder.decode(dCustomValue, "utf-8");
    }

}
