/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.autologin.DecryptDataParam;
import cn.com.duiba.cloud.manage.service.api.remoteservice.autologin.RemoteAutoLoginService;
import cn.com.duiba.cloud.manage.service.api.utils.CookieUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLoginUtil {
    private static final Logger log = LoggerFactory.getLogger(AutoLoginUtil.class);

    public static ConsumerCookieDTO getConsumerInfo() {
        String timestamp = "";
        String encodeConsumerData = "";
        Cookie[] cookies = CookieUtil.getCookies();
        if (cookies == null || cookies.length == 0) {
            log.warn("[\u7528\u6237\u4fe1\u606f] \u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u65e0cookie");
            return null;
        }
        for (Cookie cookie : cookies) {
            if ("open_timestamp".equals(cookie.getName())) {
                timestamp = cookie.getValue();
                continue;
            }
            if (!"open_consumer_data".equals(cookie.getName())) continue;
            encodeConsumerData = cookie.getValue();
        }
        if (StringUtils.isBlank((CharSequence)timestamp) || StringUtils.isBlank((CharSequence)encodeConsumerData)) {
            log.warn("[\u7528\u6237\u4fe1\u606f] \u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0ccookie\u7f3a\u5931");
            return null;
        }
        try {
            RemoteAutoLoginService remoteAutoLoginService = (RemoteAutoLoginService)SpringUtil.getApplicationContext().getBean(RemoteAutoLoginService.class);
            DecryptDataParam decryptDataParam = DecryptDataParam.builder().data(encodeConsumerData).timestamp(Long.valueOf(timestamp)).build();
            String dataJson = remoteAutoLoginService.cookieDataDecrypt(decryptDataParam);
            return (ConsumerCookieDTO)JSON.parseObject((String)dataJson, ConsumerCookieDTO.class);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u4fe1\u606f\u83b7\u53d6\u5931\u8d25,\u53ef\u80fd\u767b\u9646\u4fe1\u606f\u5df2\u8fc7\u671f\u6216\u8005\u5047\u6570\u636e", (Throwable)e);
            return null;
        }
    }

    public static String getTransfer() {
        return CookieUtil.getCookieValue("open_transfer");
    }

    public static String getDCustom() throws UnsupportedEncodingException {
        String dCustomValue = CookieUtil.getCookieValue("open_dcustom");
        if (StringUtils.isBlank((CharSequence)dCustomValue)) {
            return null;
        }
        return URLDecoder.decode(dCustomValue, "utf-8");
    }
}

