package cn.com.duiba.cloud.manage.service.api.config;

import cn.com.duiba.cloud.manage.service.api.handler.DataMaskingHandler;
import cn.com.duiba.cloud.manage.service.api.interceptor.DataMaskingClassInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @program: duiba-manage-service
 * @description: 项目Web配置
 * @author: 郭云龙
 * @create: 2021-11-25 16:10
 **/
@Configuration
@ConditionalOnProperty(prefix = "data.masking",name = "enable",havingValue = "true")
public class WebAppConfig implements WebMvcConfigurer {

    // SpringMVC 需要手动添加拦截器
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        DataMaskingClassInterceptor interceptor = new DataMaskingClassInterceptor();
        registry.addInterceptor(interceptor);
        WebMvcConfigurer.super.addInterceptors(registry);
    }

    @Bean
    @ConditionalOnMissingBean(DataMaskingClassInterceptor.class)
    public DataMaskingClassInterceptor dataMaskingClassInterceptor(){
        return new DataMaskingClassInterceptor();
    }
    @Bean
    @ConditionalOnMissingBean(DataMaskingHandler.class)
    public DataMaskingHandler dataMaskingHandler(){
        return new DataMaskingHandler();
    }
}
