package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author: xiaotian
 * @date: 2022/4/24 15:54
 * @description: 商城应用app环境配置
 */
@Data
public class MallAppEnvConfDTO implements Serializable {

    private static final long serialVersionUID = 4505822322475463160L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 商城应用id
     */
    private Long appId;

    /**
     * 是否开启app环境判断设置 0:关闭 1:开启
     */
    private Integer openEnv;

    /**
     * 判断方式 1:通过UA判断  2:通过特殊方式判断
     */
    private Integer judgeType;

    /**
     * ua标识
     */
    private String uaText;

    /**
     * ios判断方法
     */
    private String iosText;

    /**
     * 安卓判断方法
     */
    private String androidText;

}