package cn.com.duiba.cloud.manage.service.api.model.param.staff;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author linzhou
 * @ClassName GetInviteStaffListParam.java
 * @createTime 2021年11月02日 12:06:00
 * @Description 邀请列表param
 */
public class RemoteStaffInviteListRequest implements Serializable {
    /**
     * 租户编号 不必填
     */
    private Long tenantId;
    /**
     * 手机号或者人员名 不必填
     */
    private String mobile;
    private String nameOrUserId;
    /**
     * 邀请状态
     */
    private Integer inviteState;


    /**
     * ids
     */
    private List<Long> ids;


    /**
     * 当前页码。从1开始计数
     */
    private int pageNo;

    /**
     * 每页记录数
     */
    private int pageSize;

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getNameOrUserId() {
        return nameOrUserId;
    }

    public void setNameOrUserId(String nameOrUserId) {
        this.nameOrUserId = nameOrUserId;
    }

    public Integer getInviteState() {
        return inviteState;
    }

    public void setInviteState(Integer inviteState) {
        this.inviteState = inviteState;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}
