package cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppDuibaConfDTO;

/**
 * @author zhengjianhao
 * @date 2022/3/29
 * @description 商城应用-兑吧管理后台应用配置
 */
@AdvancedFeignClient
public interface RemoteMallAppDuibaConfService {

	/**
	 * 查询商城应用基础配置
	 */
	MallAppDuibaConfDTO getDuibaConf(Long appId);

	/**
	 * 保存商城应用基础配置
	 */
	void saveDuibaConf(MallAppDuibaConfDTO mallAppDuibaConfDTO) throws BizException;

	/**
	 * 查询是否已绑定1.0app
	 */
	boolean checkBindStatus(Long appId);

	/**
	 * 根据积分商城1.0appId查询
	 */
	MallAppDuibaConfDTO getByRelationAppId(Long relationAppId);

	/**
	 * 根据积分商城1.0appKey查询
	 */
	MallAppDuibaConfDTO getByRelationAppKey(String relationAppKey);
}
