package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;

/**
 * @author: 郑建豪
 * @date: 2022/6/7 11:46
 * @description: 商城的等级权益配置
 */
@Data
public class MallAppVipInterestConfDTO implements Serializable {

    private static final long serialVersionUID = -238488229227300381L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 商城应用id
     */
    private Long appId;

    /**
     * 权益名称
     */
    private String interestName;

    /**
     * 权益图标
     */
    private String interestIcon;

    /**
     * 权益类型:1，积分倍率；2，赠送积分；3、自定义权益
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.mallapp.InterestTypeEnum
     */
    private Integer interestType;

    /**
     * 积分倍率
     */
    private String creditsRatio;

    /**
     * 赠送积分值
     */
    private Long sendCredits;

    /**
     * 权益说明
     */
    private String detail;

}