package cn.com.duiba.cloud.manage.service.api.model.dto.operation.assistant.shortlink;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 短链任务DTO
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 13:52
 * @since 0.0.7
 **/
@Data
public class ShortLinkTaskDTO implements Serializable {
    private static final long serialVersionUID = 469327229287209079L;

    /**
     * 任务id
     */
    private Long id;

    /**
     * 导入数量
     */
    private Long importNum;

    /**
     * 转换成功数
     */
    private Long conversionSuccessNum;

    /**
     * 转换失败数
     */
    private Long conversionFailNum;

    /**
     * 任务备注
     */
    private String taskRemark;

    /**
     * 任务状态(1:已完成,2:转换中,3:生成中,4:已生成)
     */
    private Integer taskStatus;

    /**
     * 导入文件地址
     */
    private String importFileUrl;

    /**
     * 导出文件地址
     */
    private String exportFileUrl;

    /**
     * 创建人sso_id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
