package cn.com.duiba.cloud.manage.service.api.model.enums.mallapp;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author: 郑建豪
 * @date: 2022/6/8 16:59
 * @description: 会员类型
 */
@Getter
@AllArgsConstructor
public enum VipTypeEnum {
    VIP_GRADE("vipGrade", "会员等级"),
    ;

    private String type;
    private String desc;

    public static VipTypeEnum getByType(String type){
        if(StringUtils.isBlank(type)){
            return null;
        }
        for(VipTypeEnum vipTypeEnum: VipTypeEnum.values()){
            if(vipTypeEnum.getType().equals(type)){
                return vipTypeEnum;
            }
        }
        return null;
    }
}
