package cn.com.duiba.cloud.manage.service.api.model.param.mallfurnish;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 复制页面
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/6/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RemoteMallAppPageCopyParam extends BaseParam {

    private static final long serialVersionUID = -4947409099563517410L;

    /**
     * 复制对源页面id
     */
    @NotNull(message = "源页面id不能为空")
    private Long sourceId;

    /**
     * 页面名称
     */
    @NotBlank(message = "页面名称不能为空")
    @Size(max = 10, message = "页面名称不能超过10个字符")
    private String pageTitle;


}
