package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppTypeDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppTypeUpdateParam;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description
 * @date 2021/12/27 09:58
 */
@AdvancedFeignClient
public interface RemoteAppTypeService {


    /**
     * 应用类型列表
     * @return
     */
    public List<AppTypeDTO> getTypeList() throws BizException;

    /**
     * 应用类型修改
     * @param param
     * @return
     */
    public Integer update(@RequestBody RemoteAppTypeUpdateParam param) throws BizException;

    /**
     * 应用类型下拉列表
     *
     * @return
     */
    public List<AppTypeDTO> selectList() throws BizException;
}
