package cn.com.duiba.cloud.manage.service.api.model.dto.mallapp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: 郑建豪
 * @date: 2022/3/28 15:53
 * @description: 商城应用基础配置
 */
@Data
public class MallAppBaseConfDTO implements Serializable {

    private static final long serialVersionUID = 9136289941527660731L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 商城应用id
     */
    private Long appId;

    /**************************** 积分单位基础配置 **************************/

    /**
     * 积分单位名称
     */
    private String unitName;

    /**
     * 是否开启积分不足引导：0，不开启；1，开启
     */
    private Integer openCreditsUnenoughGuide;

    /**
     * 获取积分文案
     */
    private String earnCreditsLetter;

    /**
     * 获取积分链接
     */
    private String earnCreditsUrl;

    /**
     * 积分汇率
     */
    private Long exchangeRate;

    /**
     * 积分有效期类型:1-永久有效;2-指定时间过期;3-按笔过期
     */
    private Integer expireType;

    /**
     * 指定时间过期(几年后)
     */
    private Integer targetYear;

    /**
     * 指定时间过期:只根据月日计算过期时间
     */
    private Date expireTime;

    /**
     * 按笔过期:积分有效期天数
     */
    private Long validDayNum;

    /**
     * 品牌logo
     */
    private String brandLogo;
    /**************************** 托管配置 ***************************/

    /**
     * 用户体系模式 0:对接模式;1:托管模式
     */
    private Integer userMode;

    /**
     * 会员体系模式 0:对接模式;1:托管模式
     */
    private Integer memberMode;

    /**
     * 积分体系模式 0:对接模式;1:托管模式
     */
    private Integer creditsMode;

    /**
     * 标签体系模式 0:对接模式;1:托管模式
     */
    private Integer labelMode;

    /**************************** 接口配置 **************************/

    /**
     * 免登接口
     */
    private String unloginUrl;

    /**
     * 微信公众号免登接口
     */
    private String mpUnloginUrl;

    /**
     * 微信小程序免登接口
     */
    private String xcxUnloginUrl;

    /**
     * 扣积分接口地址
     */
    private String consumeCreditsUrl;

    /**
     * 加积分接口地址
     */
    private String addCreditsUrl;

    /**
     * 通知接口地址
     */
    private String creditsConsumeNotifyUrl;

    /**
     * 虚拟商品充值接口地址
     */
    private String virtualExchangeUrl;

    /**************************** 登录配置 **************************/

    /**
     * 开发者配置唤起登录代码
     */
    private String callUpCode;

    /**
     * 开发者配置唤起登录注册h5
     */
    private String callUpRegistH5;

    /**************************** 会员运营基础配置 **************************/

    /**
     * 是否开启会员运营：0，不开启；1，开启
     */
    private Integer openVipOperate;
    /**
     * 是否开启引导会员升级：0，不开启；1，开启
     */
    private Integer openGuideUpgrade;

    /**
     * 引导升级文案
     */
    private String guideUpgradeLetter;

    /**
     * 引导升级链接
     */
    private String guideUpgradeUrl;

    /**
     * 成长值名称
     */
    private String growthValueName;

    /**
     * 等级有效期：天
     */
    private Integer vipPeriod;

    /**
     * 降级方式：1、降一级；2、重置等级
     *
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.mallapp.DemotionTypeEnum
     */
    private Integer demotionType;
}