package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.wolf.utils.DateUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.Objects;

public class CookieUtil {

    /**
     * 获取cookie信息
     *
     * @param name
     * @return
     */
    public static String getCookieValue(String name) {
        // 获取cookie中的数据
        Cookie[] cookies = getRequest().getCookies();
        for (Cookie cookie : cookies) {
            if (name.equals(cookie.getName())) {
                return cookie.getValue();
            }
        }
        return null;
    }

    public static Cookie[] getCookies() {
        return getRequest().getCookies();
    }

    /**
     * @param name
     * @return
     */
    private static Cookie createCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        return cookie;
    }

    public static void setCookie(String name, String value) {
        Cookie cookie = createCookie(name, value);
        getResponse().addCookie(cookie);
    }

    public static void setCookie(String name, String value, String domain) {
        Cookie cookie = createCookie(name, value, domain);
        getResponse().addCookie(cookie);
    }

    public static Cookie createSession24Cookie(String name, String value, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setDomain(domain);
        cookie.setMaxAge(24 * 60 * 60);
        return cookie;
    }

    public static Cookie createCookie(String name, String value, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setDomain(domain);
        return cookie;
    }

    /**
     * 今日有效的cookie
     */
    public static void setCrossCookie4Today(String name, String value, String domain) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setDomain(domain);
        Date now = new Date();
        cookie.setMaxAge((int) (DateUtils.getDayEndTime(now).getTime() - now.getTime()) / 1000);
        getResponse().addCookie(cookie);
    }

    public static void setCrossCookieFor24Hour(String name, String value, String domain) {
        Cookie cookie = createSession24Cookie(name, value, domain);
        getResponse().addCookie(cookie);
    }

    public static void deleteCookie(String name) {
        Cookie cookie = createCookie(name, null);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        getResponse().addCookie(cookie);
    }

    public static void deleteCookie(String name, String domain) {
        Cookie cookie = createCookie(name, null);
        cookie.setPath("/");
        cookie.setDomain(domain);
        cookie.setMaxAge(0);
        getResponse().addCookie(cookie);
    }


    private static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getResponse();
    }

    private static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
    }
}
