package cn.com.duiba.cloud.manage.service.api.model.param.operation.assistant.shortlink;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 分页查询生成短链任务请求参数
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @date 2022-06-16 13:46
 * @since 0.0.7
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class RemotePageListShortLinkTaskParam extends PageRequest {
    private static final long serialVersionUID = 7218490762750185788L;

    /**
     * 创建人（操作人）
     */
    private Long createBy;

    /**
     * 操作开始时间
     */
    private Date startTime;

    /**
     * 操作结束时间
     */
    private Date endTime;

    /**
     * 分页查询时，是否需要查询总数<br>
     * 默认false，不查询
     */
    private Boolean isSearchCount = false;
}
