package cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipGradeDTO;

import java.util.List;

/**
 * @author: 郑建豪
 * @date: 2022/6/7 21:09
 * @description: 商城应用会员等级配置
 */
@AdvancedFeignClient
public interface RemoteMallAppVipLevelConfService {

	/**
	 * 获取app下所有会员等级配置-不包含成员人数
	 */
	List<MallAppVipGradeDTO> getAllByAppId(Long appId);

	/**
	 * 获取app下所有会员等级配置-包含成员人数
	 */
	List<MallAppVipGradeDTO> getAllWithMemberByAppId(Long appId);

	/**
	 * 根据等级权重获取app下该权重的配置
	 */
	MallAppVipGradeDTO getByAppGrade(Long appId, Integer grade);

	/**
	 * 根据等级权重获取app下该权重的等级标识
	 */
	String getDevTagByAppGrade(Long appId, Integer grade);

	/**
	 * 根据等级标识获取app下该标识的配置，如果没有匹配的，或者标识为空，返回基础等级配置
	 */
	MallAppVipGradeDTO getByAppDevTag(Long appId, String devTag);

	/**
	 * 保存等级权重配置
	 */
	Long save(MallAppVipGradeDTO dto);

	/**
	 * 删除等级权重配置
	 */
	void deleteByGrade(Long appId, Integer grade);

	/**
	 * 增加等级成员人数，+1
	 */
	void increaseGradeMemberCount(Long appId, Integer grade);

	/**
	 * 修改等级成员人数，旧等级减少一人，新的等级增加一人
	 */
	void convertGradeMemberCount(Long appId, Integer oldGrade, Integer newGrade);

	/**
	 * 批量插入
	 * @param dto
	 * @return
	 */
	Long batchSave(List<MallAppVipGradeDTO> dto);

}
