package cn.com.duiba.cloud.manage.service.api.model.enums;

/**
 * @program: duiba-manage-service
 * @description: 套餐版本枚举
 * @author: 郭云龙
 * @create: 2022-03-24 15:09
 **/

public enum VersionTypeEnum  {
    TRIAL(0L,"试用版",ServiceTimeEnum.SEVEN_DAYS.getServiceTimeId()),
    FORMAL(1L,"正式版",ServiceTimeEnum.ONE_YEAR.getServiceTimeId()),
    ;

    private Long versionTypeId;
    private String versionTypeName;

    /**
     * 默认时长ID
     */
    private Long defaultServiceTimeId;

    VersionTypeEnum(Long versionTypeId, String versionTypeName,Long defaultServiceTimeId) {
        this.versionTypeId = versionTypeId;
        this.versionTypeName = versionTypeName;
        this.defaultServiceTimeId = defaultServiceTimeId;
    }

    public Long getVersionTypeId() {
        return versionTypeId;
    }

    public String getVersionTypeName() {
        return versionTypeName;
    }

    public Long getDefaultServiceTimeId() {
        return defaultServiceTimeId;
    }
}
