package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteTenantAppPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteTenantAppUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 租户应用服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/30
 */
@AdvancedFeignClient
public interface RemoteTenantAppService {

    /**
     * 租户订阅应用的分页查询
     *
     * @param remoteParam 入参
     * @return 分页列表
     * @throws BizException 业务异常
     */
    PageResponse<TenantAppDTO> pageQuery(RemoteTenantAppPageQueryParam remoteParam) throws BizException;

    /**
     * 通过id查询详情
     *
     * @param id 租户应用id
     * @return 详情
     * @throws BizException 业务异常
     */
    TenantAppDTO detail(Long id) throws BizException;

    /**
     * 更新租户应用信息
     *
     * @param remoteParam 入参
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean update(RemoteTenantAppUpdateParam remoteParam) throws BizException;

}
