package cn.com.duiba.cloud.manage.service.api.remoteservice.app;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.BusinessEntityRecordDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppSimpleDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppTokenDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.tenant.TenantDbDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteBusinessEntityPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteTenantAppPageQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteTenantAppUpdateParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 租户应用服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/30
 */
@AdvancedFeignClient
public interface RemoteTenantAppService {

    /**
     * 租户订阅应用的分页查询
     *
     * @param remoteParam 入参
     * @return 分页列表
     * @throws BizException 业务异常
     */
    PageResponse<TenantAppDTO> pageQuery(RemoteTenantAppPageQueryParam remoteParam) throws BizException;

    /**
     * 通过id查询详情
     *
     * @param id 租户应用id
     * @return 详情
     * @throws BizException 业务异常
     */
    TenantAppDTO detail(Long id) throws BizException;

    /**
     * 更新租户应用信息
     *
     * @param remoteParam 入参
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean update(RemoteTenantAppUpdateParam remoteParam) throws BizException;

    /**
     * 业务主体记录分页查询
     *
     * @param remoteParam 入参
     * @return 分页列表
     * @throws BizException 业务异常
     */
    PageResponse<BusinessEntityRecordDTO> pageQueryBusinessEntityRecord(RemoteBusinessEntityPageQueryParam remoteParam) throws BizException;

    /**
     * 通过租户应用id查询租户信息
     *
     * @param tenantAppId
     * @return
     * @throws BizException
     */
    TenantDbDTO getTenantInfoByAppId(Long tenantAppId) throws BizException;

    /**
     * 通过租户应用id查询应用信息
     *
     * @param tenantAppId
     * @return
     * @throws BizException
     */
    TenantAppSimpleDTO getInfoByTenantAppId(Long tenantAppId) throws BizException;

    /**
     * 获取访问租户应用所需数据
     *
     * @param tenantAppId
     * @throws BizException
     */
    TenantAppTokenDTO getVisitTenantAppToken(Long tenantAppId) throws BizException;

    /**
     * 租户订阅应用下拉列表
     * @param keyword
     * @return
     * @throws BizException
     */
    List<TenantAppDTO> selectListByIdAndName(String keyword) throws BizException;

}
