package cn.com.duiba.cloud.manage.service.api.model.dto.app;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 租户应用dto。简单对象，字段和数据库一一匹配
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/4/1
 */
@Getter
@Setter
public class TenantAppSimpleDTO implements Serializable {

    private static final long serialVersionUID = -2419518520096830353L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * appTypeId
     */
    private Long appTypeId;

    /**
     * 应用订阅唯一标识，全局唯一
     */
    private String appKey;

    /**
     * 应用密钥
     */
    private String appSecret;

    /**
     * 状态 0-无效 1-有效
     */
    private Integer state;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建者
     */
    private Long createdBy;

    /**
     * 修改人
     */
    private Long modifiedBy;

    /**
     * 租户应用名称
     */
    private String tenantAppName;

    /**
     * 业务主体ID 与枚举BusinessEntityEnum对应，1-兑吧 2-兑啊 3-兑捷
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.BusinessEntityEnum
     */
    private Long businessEntityId;

    /**
     * 应用标签ID 与枚举TenantAppTagEnum对应，0-无标签 1-客户测试 2-客户生产 3-内部测试
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.TenantAppTagEnum
     */
    private Long tenantAppTagId;

}
