package cn.com.duiba.cloud.manage.service.api.model.param.store;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 09:50
 */
@Getter
@Setter
public class RemoteStoreEnableOrDisableParam extends BaseParam {

    /**
     * 门店id
     */
    @NotNull(message = "门店id不能为空")
    private Long id;

    /**
     * 状态 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.StoreStateEnum}
     */
    @NotNull(message = "状态参数不能为空")
    @Min(value = 0, message = "请求参数state不合法")
    @Max(value = 1, message = "请求参数state不合法")
    private Integer state;
}
