package cn.com.duiba.cloud.manage.service.api.remoteservice.store;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppIdNameDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppSimpleDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.store.StoreDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.store.StoreDiscountDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.store.StoreDiscountPageDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteAppDetailQueryParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreDiscountAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreDiscountDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreDiscountEditParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreDiscountEnableOrDisableParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreDiscountPageParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreListParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-13 15:02:05
*/
@AdvancedFeignClient
public interface RemoteStoreDiscountService {

    /**
     * 分页查询门店优惠
     * @param param 查询参数
     * @return 门店优惠分页结果
     */
    PageResponse<StoreDiscountPageDTO> page(RemoteStoreDiscountPageParam param);

    /**
     * 上架、下架门店优惠
     * @param param 操作参数
     * @throws BizException 操作异常
     */
    void enableOrDisable(RemoteStoreDiscountEnableOrDisableParam param) throws BizException;

    /**
     * 新增优惠
     * @param param 新增参数
     * @return 优惠id
     * @throws BizException 查询异常
     * @throws InterruptedException 加锁异常
     */
    Long add(RemoteStoreDiscountAddParam param) throws BizException, InterruptedException;

    /**
     * 查看门店优惠详情
     * @param param 查询参数
     * @return 优惠详情
     * @throws BizException 查询异常
     */
    StoreDiscountDetailDTO detail(RemoteStoreDiscountDetailParam param) throws BizException;

    /**
     * 编辑门店优惠信息
     * @param param 编辑参数
     * @throws BizException 操作异常
     */
    void edit(RemoteStoreDiscountEditParam param) throws BizException;

    /**
     * 查询省市区下的门店列表
     * @param param 查询参数
     * @return 门店列表
     * @throws BizException 查询异常
     */
    List<StoreDTO> storeList(RemoteStoreListParam param) throws BizException;

    /**
     * 根据订阅应用ID获取订阅应用详情
     * @param param 查询参数
     * @return 应用详情
     * @throws BizException 查询异常
     */
    AppSimpleDTO tenantAppDetail(RemoteAppDetailQueryParam param) throws BizException;

    /**
     * 查看供应商列表
     * @param appId 应用id
     * @return 供应商列表
     * @throws BizException 查询异常
     */
    List<AppIdNameDTO> supplierList(Long appId) throws BizException;
}
