package cn.com.duiba.cloud.manage.service.api.model.dto.app;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 业务主体变更记录
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/31
 */
@Getter
@Setter
public class BusinessEntityRecordDTO implements Serializable {

    private static final long serialVersionUID = -7552419819403958101L;

    /**
     * id
     */
    private Long id;

    /**
     * 租户应用id
     */
    private Long tenantAppId;

    /**
     * 业务主体ID 与枚举BusinessEntityEnum对应，1-兑吧 2-兑啊 3-兑捷
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.BusinessEntityEnum
     */
    private Integer oldBusinessEntity;

    /**
     * 业务主体ID 与枚举BusinessEntityEnum对应，1-兑吧 2-兑啊 3-兑捷
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.BusinessEntityEnum
     */
    private Integer newBusinessEntity;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 创建人
     */
    private Long createdBy;

}
