package cn.com.duiba.cloud.manage.service.api.model.enums.app;

import java.util.Arrays;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/1/6 15:44
 */
public enum AppTypeEnum {


    /**
     * 应用类型枚举
     */
    SUPPLIER(2L, "供应商"),
    MALL(3L, "商城"),
    PURCHASER(4L, "采购商")
    ;

    private final Long id;
    private final String name;

    AppTypeEnum(Long id, String name) {
        this.id = id;
        this.name = name;
    }

    public Long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static String getNameById(Long id){
        return Arrays.stream(AppTypeEnum.values())
                .filter(o -> id.equals(o.getId()))
                .findFirst().orElse(AppTypeEnum.MALL)
                .getName();
    }
}
