package cn.com.duiba.cloud.manage.service.api.model.param.audit;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @program: duiba-manage-service
 * @description: 批量审核撤销参数
 * @author: 郭云龙
 * @create: 2021-11-08 09:56
 **/
@Getter
@Setter
@ToString
@Accessors(chain = true)
public class RemoteRevokeListParam extends BaseParam {

    /**
     * 业务单号
     */
    @NotEmpty(message = "业务单号列表不能为空")
    private List<String> bizNoList;
    /**
     * 业务类型
     */
    @NotNull(message = "业务类型不能为空")
    private String bizType;
}
