package cn.com.duiba.cloud.manage.service.api.model.param.customer;

import cn.com.duiba.cloud.manage.service.api.model.param.PageBaseParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 客服配置表
 * @author kjj mybatis generator 
 * @date 2022-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CustomerServiceRuleSearchParam extends PageBaseParam {
     
    private static final long serialVersionUID = 16488426632645012L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * APP ID
     */
    private Long appId;

    /**
     * 是否跳转客服FAQ中间页
     */
    private Byte customerServiceMiddlePage;

    /**
     * 是否直接跳转人工客服
     */
    private Byte customerServiceByPeople;

    /**
     * 活动ID列表，json数组格式
     */
    private String activityIds;

    /**
     * 生效地区，json格式，为null表示不限制
     */
    private String validRegions;

    /**
     * 露出页枚举值数组 1兑换记录页  2兑吧-商品详情页  3兑吧-订单记录页  4自有-商品详情页 5自有-订单记录页 0商品详情页配置
     */
    private String revealPage;

    /**
     * 客服信息露出
     */
    private Byte isOpen;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}