package cn.com.duiba.cloud.manage.service.api.model.param.store;

import cn.com.duiba.cloud.manage.service.api.model.enums.store.CallTypeEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.store.DiscountTypeEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.store.GoodsSourceEnum;
import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import cn.com.duiba.cloud.manage.service.api.utils.EnumValid;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 11:06
 */
@Getter
@Setter
public class RemoteStoreDiscountEditParam extends BaseParam {

    /**
     * 门店优惠id
     */
    @NotNull(message = "门店优惠id不能为空")
    @Max(value = Long.MAX_VALUE, message = "门店优惠id长度超过限制")
    private Long id;

    /**
     * 唤端类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.store.CallTypeEnum
     */
    @NotNull(message = "唤端类型不能为空")
    @EnumValid(target = CallTypeEnum.class, message = "唤端类型不合法")
    private Integer callType;

    /**
     * 优惠类型
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.store.DiscountTypeEnum
     */
    @NotNull(message = "优惠类型不能为空")
    @EnumValid(target = DiscountTypeEnum.class, message = "优惠类型不合法")
    private Integer discountType;

    /**
     * 商品来源
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.store.GoodsSourceEnum
     */
    @NotNull(message = "商品来源不能为空")
    @EnumValid(target = GoodsSourceEnum.class, message = "商品来源不合法")
    private Integer source;

    /**
     * 商品名称
     */
    @Size(max = 20, message = "商品名称长度超过限制")
    @NotBlank(message = "商品名称不能为空")
    private String goodsName;

    /**
     * 商品描述
     */
    @Size(max = 50, message = "商品描述长度超过限制")
    private String goodsDesc;

    /**
     * 单位id
     */
    @NotBlank(message = "单位类型不能为空")
    private String unitType;

    /**
     * 商品价格
     */
    @NotNull(message = "商品价格不能为空")
    @Positive(message = "商品价格必须大于0")
    private Double goodsPrice;

    /**
     * 商品链接
     */
    @NotBlank(message = "商品链接不能为空")
    private String goodsLink;

    /**
     * 供应商应用id
     */
    @Max(value = Long.MAX_VALUE, message = "供应商应用id长度超过最大限制")
    @NotNull(message = "供应商应用id不能为空")
    private Long supplierAppId;

    /**
     * 门店id
     */
    @NotEmpty(message = "门店id list不能为空")
    private List<String> storeIdList;
}
