package cn.com.duiba.cloud.manage.service.api.model.param.store;

import cn.com.duiba.cloud.manage.service.api.model.param.PageBaseParam;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/5/12 09:45
 */
@Getter
@Setter
public class RemoteStorePageParam extends PageBaseParam {

    /**
     * 门店id
     */
    @Max(value = Long.MAX_VALUE, message = "门店id长度超过最大限制")
    private Long id;

    /**
     * 门店名称
     */
    private String name;

    /**
     * 门店地区
     */
    @NotBlank(message = "门店地区不能为空")
    private List<String> addressCode;

    /**
     * 状态 {@link cn.com.duiba.cloud.manage.service.api.model.enums.store.StoreStateEnum}
     * 为空表示查询全部
     */
    private Integer state;
}
