package cn.com.duiba.cloud.manage.service.api.remoteservice.store;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.store.StoreDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.store.StoreDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.store.StorePageDTO;
import cn.com.duiba.cloud.manage.service.api.model.dto.store.StoreSettingDTO;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreAddParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreDetailParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreEditParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreEnableOrDisableParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStorePageParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreSettingParam;
import cn.com.duiba.cloud.manage.service.api.model.param.store.RemoteStoreSettingQueryParam;
import cn.com.duiba.wolf.entity.PageResponse;

import javax.validation.constraints.NotNull;

/**
* @author yuanzhixin
* @version 1.0
* @date 2022-05-13 14:59:56
*/
@AdvancedFeignClient
public interface RemoteStoreService {

    /**
     * 分页查询门店列表
     * @param param 分页查询参数
     * @return 分页列表结果
     */
    PageResponse<StorePageDTO> page(RemoteStorePageParam param);

    /**
     * 停用、启用门店
     * @param param 更新参数
     * @throws BizException 操作异常
     */
    void enableOrDisable(RemoteStoreEnableOrDisableParam param) throws BizException;

    /**
     * 门店详情】
     * @param param 查询参数
     * @return 门店详情信息
     * @throws BizException 操作异常
     */
    StoreDetailDTO detail(RemoteStoreDetailParam param) throws BizException;

    /**
     * 编辑门店信息
     * @param param 更新参数
     * @throws BizException 操作异常
     */
    void edit(RemoteStoreEditParam param) throws BizException;

    /**
     * 新增门店信息
     * @param param 新增参数
     * @return 门店id
     * @throws BizException 操作异常
     * @throws InterruptedException 加锁异常
     */
    Long add(RemoteStoreAddParam param) throws BizException, InterruptedException;

    /**
     * 查看门店设置
     * @param param 查询参数
     * @return 门店设置信息
     * @throws BizException 查询异常
     */
    StoreSettingDTO setting(RemoteStoreSettingQueryParam param) throws BizException;

    /**
     * 修改门店设置
     * @param param 更新参数
     * @throws BizException 操作异常
     */
    void updateSetting(RemoteStoreSettingParam param) throws BizException;

    /**
     * 查询门店dto
     * @param id 门店id
     * @param isDelete 是否查询已删除，true表示查询
     * @return StoreDTO
     * @throws BizException 查询异常
     */
    StoreDTO getById(@NotNull(message = "门店id不能为空") Long id, @NotNull(message = "isDelete 不能为空") Boolean isDelete) throws BizException;
}
