package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.cloud.manage.service.api.model.dto.customer.CustomerServiceRuleDto;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ClassName:ActivityFlowRuleParseUtil<br/>
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/4/18  15:21
 * @since JDK 1.8
 **/
@Slf4j
public class CustomerServiceRuleParseUtil {

    private CustomerServiceRuleParseUtil() {
        //空构造函数
    }
    public static List<Long> parseActivityIds(String activityIds) {
        if (StringUtils.isBlank(activityIds)) {
            return Collections.emptyList();
        }

        try {
            List<Long> ids = JSONObject.parseArray(activityIds, Long.class);
            if (CollectionUtils.isEmpty(ids)) {
                return Collections.emptyList();
            }
            return ids;
        } catch (Exception e) {
            log.error("json error, src={}", activityIds, e);
            return Collections.emptyList();
        }
    }

    public static Set<String> parseRegions(String regions) {
        if (StringUtils.isBlank(regions)) {
            return null;
        }
        try {
            List<String> regionList = JSONObject.parseArray(regions, String.class);
            return new HashSet<>(regionList);
        } catch (Exception e) {
            log.error("json error, src={}", regions, e);
            return null;
        }
    }

    //设置活动限制，当为空表示所有活动可以通过，空数组表示没有活动可以通过
    public static List<Long> parseActivityIdsAllowNull(String activityIds) {
        if (StringUtils.isBlank(activityIds)) {
            return null;
        }

        try {
            List<Long> ids = JSONObject.parseArray(activityIds, Long.class);
            if (CollectionUtils.isEmpty(ids)) {
                return Collections.emptyList();
            }
            return ids;
        } catch (Exception e) {
            log.error("json error, src={}", activityIds, e);
            return Collections.emptyList();
        }
    }
}