package cn.com.duiba.cloud.manage.service.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.model.enums.tenant.RsTenantStateEnum;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

/**
 * @author linzhou
 * @ClassName EnumUtil.java
 * @createTime 2021年12月17日 14:21:00
 * @Description 枚举工具类
 */
public class EnumUtil {

    public static  <T extends Enum<T>> T getEnum( Class<T> enumClass,Object code) throws BizException {
        T[] values = values(enumClass);
        Field field = getCodeField(enumClass);
        AssertUtil.isNotNull(field, ErrorCode.ENUM_UTIL_GET_FIELD_IS_NULL);
        field.setAccessible(true);
        if (Objects.nonNull(values)) {
            for (T value : values) {
                Object o = getFieldValue(field, value);
                if (Objects.nonNull(o) && Objects.equals(code, o)) {
                    return value;
                }
            }
        }

        return null;
    }

    public static  <T extends Enum<T>> T getEnumDefaultNull( Class<T> enumClass,Object code){
        try {
            return getEnum(enumClass,code);
        } catch (BizException e) {
            return null;
        }
    }

    private static Object getFieldValue(Field field, Object o) {
        try {
            return field.get(o);
        } catch (IllegalAccessException e) {
            return null;
        }
    }

    private static  <T extends Enum<T>> Field getCodeField(Class<T> enumClass) {
        for (Field field : enumClass.getDeclaredFields()) {
            Code code = field.getAnnotation(Code.class);
            String name = field.getName();
            if (Objects.nonNull(code) || "code".equals(name)) {
                return field;
            }
        }
        return null;
    }


    /**
     * 通过反射调用枚举类的values获取所有枚举类
     *
     * @param enumClass
     * @param <E>
     */
    private static <E extends Enum<E>> E[] values(Class<E> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values");
            Object valuesObj = valuesMethod.invoke(enumClass);
            E[] values = (E[]) valuesObj;
            return values;
        } catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) throws BizException {
        RsTenantStateEnum anEnum = getEnum(RsTenantStateEnum.class, 1);
        RsTenantStateEnum anEnum2 = getEnum(RsTenantStateEnum.class, 2);
        RsTenantStateEnum anEnum3 = getEnum(RsTenantStateEnum.class, 3);
        RsTenantStateEnum anEnum4 = getEnum(RsTenantStateEnum.class, 4);
    }
}
