/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.api.config;

import cn.com.duiba.cloud.manage.service.api.handler.DataMaskingHandler;
import cn.com.duiba.cloud.manage.service.api.interceptor.DataMaskingClassInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="data.masking", name={"enable"}, havingValue="true")
public class WebAppConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        DataMaskingClassInterceptor interceptor = new DataMaskingClassInterceptor();
        registry.addInterceptor((HandlerInterceptor)interceptor);
        super.addInterceptors(registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={DataMaskingClassInterceptor.class})
    public DataMaskingClassInterceptor dataMaskingClassInterceptor() {
        return new DataMaskingClassInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={DataMaskingHandler.class})
    public DataMaskingHandler dataMaskingHandler() {
        return new DataMaskingHandler();
    }
}

