package cn.com.duiba.cloud.manage.service.api.model.dto.audit;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @program: duiba-manage-service
 * @description: 审核
 * @author: 郭云龙
 * @create: 2021-11-09 11:19
 **/
@Data
public class AuditDTO implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 业务单号
     */
    private String bizNo;

    /**
     * 业务类型，作为topic的tag进行发送
     */
    private String bizType;

    /**
     * 审核状态 0-待审核 1-审核通过 2-审核拒绝
     */
    private String state;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改人
     */
    private Long modifiedBy;

    private static final long serialVersionUID = 1L;
}
