package cn.com.duiba.cloud.manage.service.api.remoteservice.mallapp;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.manage.service.api.model.dto.mallapp.MallAppVipLevelInterestDTO;

import java.util.List;

/**
 * @author: 郑建豪
 * @date: 2022/6/7 21:09
 * @description: 商城等级的权益
 */
@AdvancedFeignClient
public interface RemoteMallAppVipLevelInterestService {

	/**
	 * 批量新增等级权益
	 */
	void insertBatch(List<MallAppVipLevelInterestDTO> dtoList) throws BizException;

	/**
	 * 根据appId批量获取等级权益
	 */
	List<MallAppVipLevelInterestDTO> getListByAppId(Long appId);

	/**
	 * 根据appId、等级权重批量获取等级权益
	 */
	List<MallAppVipLevelInterestDTO> getListByAppGrade(Long appId, Integer grade);

	/**
	 * 根据主键id列表批量删除等级权益
	 */
	void deleteByIdList(List<Long> idList);

	/**
	 * 根据权益id批量删除等级权益
	 */
	void deleteByInterestId(Long interestId);

	/**
	 * 根据app等级批量删除等级权益
	 */
	void deleteByAppGrade(Long appId, Integer grade);
}
