/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.autologin.sdk.constant.OpenApiSdkErrorCode;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.OpenApiInterceptorHandlerManager;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.annotation.CanAccess;
import cn.com.duiba.cloud.manage.service.autologin.sdk.utils.OpenApiRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class OpenApiInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OpenApiInterceptor.class);
    @Resource
    private OpenApiInterceptorHandlerManager manager;
    private static final Set<String> EXCLUDE_PATHS = Sets.newHashSet();

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
        if (handler instanceof ResourceHttpRequestHandler) {
            return Boolean.TRUE;
        }
        OpenApiRequestTool.setRequestInThreadLocal(request, response);
        if (this.isSpecialRequest(request, handler)) {
            return Boolean.TRUE;
        }
        try {
            if (!this.manager.doHandler(handler).booleanValue()) {
                this.interceptResponse(response, OpenApiSdkErrorCode.NO_PERMISSION.getCode(), OpenApiSdkErrorCode.NO_PERMISSION.getMsg());
                return Boolean.FALSE;
            }
        }
        catch (BizException e) {
            log.warn("openapi interceptor BizException, errorCode:{}, errorMsg:{}", (Object)e.getCode(), (Object)e.getMessage());
            this.interceptResponse(response, e.getCode(), e.getMessage());
            return Boolean.FALSE;
        }
        catch (Exception e) {
            log.error("openapi interceptor unknown Exception, error:", (Throwable)e);
            this.interceptResponse(response, OpenApiSdkErrorCode.SYSTEM_ERROR.getCode(), OpenApiSdkErrorCode.SYSTEM_ERROR.getMsg());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) throws Exception {
        OpenApiRequestTool.removeRequestInThreadLocal();
    }

    private void interceptResponse(HttpServletResponse response, String code, String message) throws IOException {
        if (OpenApiRequestTool.isAsynchronousRequests().booleanValue()) {
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            response.getWriter().write(JSONObject.toJSONString((Object)JsonResult.fail((String)code, (String)message)));
        } else {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.getWriter().write(message);
        }
    }

    private boolean isSpecialRequest(HttpServletRequest request, Object handler) {
        HandlerMethod method;
        CanAccess canAccess;
        String url = request.getRequestURI();
        if (EXCLUDE_PATHS.contains(url)) {
            return true;
        }
        if (handler instanceof HandlerMethod && (canAccess = (CanAccess)AnnotationUtils.findAnnotation((Method)(method = (HandlerMethod)handler).getMethod(), CanAccess.class)) != null) {
            return true;
        }
        return Boolean.FALSE;
    }

    static {
        EXCLUDE_PATHS.add("/favicon.ico");
        EXCLUDE_PATHS.add("/monitor/check");
        EXCLUDE_PATHS.add("/error");
    }
}

