/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.api.utils.AutoLoginUtil;
import cn.com.duiba.cloud.manage.service.autologin.sdk.config.OpenApiProperties;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.annotation.TenantAppOverdueAnnotation;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.OpenApiInterceptorHandler;
import cn.com.duiba.cloud.manage.service.autologin.sdk.utils.OpenApiRequestTool;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.CommonVerification;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

@EnableConfigurationProperties(value={OpenApiProperties.class})
public class TenantAppOverdueHandler
implements OpenApiInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantAppOverdueHandler.class);
    @Resource
    private OpenApiProperties properties;
    @Resource
    private CommonVerification commonVerification;

    @Override
    public Boolean accept(Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            TenantAppOverdueAnnotation tenantAppOverdueAnnotation = (TenantAppOverdueAnnotation)AnnotationUtils.getAnnotation((Method)method.getMethod(), TenantAppOverdueAnnotation.class);
            if (Objects.isNull(tenantAppOverdueAnnotation)) {
                return Boolean.TRUE;
            }
            String tenantAppId = OpenApiRequestTool.getRequest().getParameter(tenantAppOverdueAnnotation.fieldVerity());
            if (StringUtils.isBlank((String)tenantAppId)) {
                ConsumerCookieDTO consumerCookieDTO = AutoLoginUtil.getConsumerInfo();
                AssertUtil.isNotNull((Object)consumerCookieDTO, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
                tenantAppId = String.valueOf(consumerCookieDTO.getAppId());
            }
            AssertUtil.isNotNull((Object)tenantAppId, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
            Boolean verifyTenantAppOverdue = this.commonVerification.verifyTenantAppOverdue(Long.parseLong(tenantAppId));
            if (verifyTenantAppOverdue.booleanValue()) {
                return Boolean.TRUE;
            }
            log.error("tenantApp:{} Overdue:{} ", (Object)tenantAppId, (Object)verifyTenantAppOverdue);
            throw new BizException(ErrorCode.TENANT_APP_OVERDUE.getMsg()).withCode(ErrorCode.TENANT_APP_OVERDUE.getCode());
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 10;
    }
}

