package cn.com.duiba.cloud.manage.service.autologin.sdk.config;

import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.OpenApiInterceptor;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.OpenApiInterceptorHandlerManager;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.LoginInterceptor;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.TenantAppOverdueHandler;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.TenantAppTradeLimitHandler;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.CommonVerification;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.impl.CommonVerificationImpl;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拦截器配置
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/24
 */
@Configuration
@Order(-1)
@EnableConfigurationProperties(OpenApiProperties.class)
public class OpenApiSdkConfiguration implements WebMvcConfigurer {

    @Resource
    private OpenApiProperties properties;

    private static final List<String> DEFAULT_EXCLUDE_PATHS = Lists.newArrayList();

    static {
        DEFAULT_EXCLUDE_PATHS.add("/error");
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = properties.getPathPatterns();
        String[] paths = StringUtils.split(pathPatterns, ",");

        String excludePathPatterns = properties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{}
                : StringUtils.split(excludePathPatterns, ",");

        OpenApiInterceptor openApiInterceptor = openApiInterceptor();
        registry.addInterceptor(openApiInterceptor)
                .addPathPatterns(paths)
                .excludePathPatterns(excludePath)
                .excludePathPatterns(DEFAULT_EXCLUDE_PATHS);
    }

    @Bean
    @ConditionalOnProperty(prefix = "duiba.openapi.interceptor", value = "login", havingValue = "true", matchIfMissing = true)
    public LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiInterceptorHandlerManager openApiInterceptorHandlerManager() {
        return new OpenApiInterceptorHandlerManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenApiInterceptor openApiInterceptor() {
        return new OpenApiInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppOverdueHandler tenantAppOverdueHandler() {
        return new TenantAppOverdueHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantAppTradeLimitHandler tenantAppTradeLimitHandler() {
        return new TenantAppTradeLimitHandler();
    }


    @Bean
    @ConditionalOnMissingBean
    public CommonVerification permissionVerificationRemote() {
        return new CommonVerificationImpl();
    }

}
