package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor;

import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.OpenApiInterceptorHandler;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 开放平台拦截管理器
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/24
 */
public class OpenApiInterceptorHandlerManager {

    @Autowired(required = false)
    List<OpenApiInterceptorHandler> interceptorHandlerList;

    public Boolean doHandler(Object handler) throws Exception {
        if (interceptorHandlerList == null || interceptorHandlerList.isEmpty()) {
            return true;
        }
        for (OpenApiInterceptorHandler interceptorHandler : interceptorHandlerList) {
            if (!interceptorHandler.accept(handler)) {
                return false;
            }
        }
        return true;
    }

}
