/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.api.utils.AutoLoginUtil;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.annotation.TenantAppTradeLimitAnnotation;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler.AutoLoginInterceptorHandler;
import cn.com.duiba.cloud.manage.service.autologin.sdk.utils.AutoLoginRequestTool;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.CommonVerification;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class TenantAppTradeLimitHandler
implements AutoLoginInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantAppTradeLimitHandler.class);
    @Resource
    private CommonVerification commonVerification;

    @Override
    public Boolean accept(Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            TenantAppTradeLimitAnnotation tenantAppTradeLimitAnnotation = (TenantAppTradeLimitAnnotation)AnnotationUtils.getAnnotation((Method)method.getMethod(), TenantAppTradeLimitAnnotation.class);
            if (Objects.isNull(tenantAppTradeLimitAnnotation)) {
                return Boolean.TRUE;
            }
            String tenantAppId = AutoLoginRequestTool.getRequest().getParameter(tenantAppTradeLimitAnnotation.fieldVerity());
            if (StringUtils.isBlank((String)tenantAppId)) {
                ConsumerCookieDTO consumerCookieDTO = AutoLoginUtil.getConsumerInfo();
                AssertUtil.isNotNull((Object)consumerCookieDTO, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
                tenantAppId = String.valueOf(consumerCookieDTO.getAppId());
            }
            AssertUtil.isNotNull((Object)tenantAppId, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
            Boolean verifyTenantAppTradeLimit = this.commonVerification.verifyTenantAppTradeLimit(Long.parseLong(tenantAppId));
            if (verifyTenantAppTradeLimit.booleanValue()) {
                return Boolean.TRUE;
            }
            log.error("tenantApp:{} tradeLimitSwitch:{} ", (Object)tenantAppId, (Object)verifyTenantAppTradeLimit);
            throw new BizException(ErrorCode.TENANT_APP_TRADE_LIMIT_OPEN.getMsg()).withCode(ErrorCode.TENANT_APP_TRADE_LIMIT_OPEN.getCode());
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 11;
    }
}

