package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.api.utils.AutoLoginUtil;
import cn.com.duiba.cloud.manage.service.autologin.sdk.config.AutoLoginProperties;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.annotation.TenantAppOverdueAnnotation;
import cn.com.duiba.cloud.manage.service.autologin.sdk.utils.AutoLoginRequestTool;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.CommonVerification;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @program: duiba-manage-service
 * @description:
 * @author: 郭云龙
 * @create: 2022-05-30 15:09
 **/
@EnableConfigurationProperties(AutoLoginProperties.class)
@Slf4j
public class TenantAppOverdueHandler implements AutoLoginInterceptorHandler {

    @Resource
    private AutoLoginProperties properties;

    @Resource
    private CommonVerification commonVerification;
    @Override
    public Boolean accept(Object handler) throws Exception {

        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;

            TenantAppOverdueAnnotation tenantAppOverdueAnnotation = AnnotationUtils.getAnnotation(method.getMethod(), TenantAppOverdueAnnotation.class);

            //如果注解不存在，直接返回
            if(Objects.isNull(tenantAppOverdueAnnotation)){
                return Boolean.TRUE;
            }

            //获取参数的需继续联调，防止取不到信息
            String tenantAppId = AutoLoginRequestTool.getRequest().getParameter(tenantAppOverdueAnnotation.fieldVerity());
            //如果取不到值，通过cookie获取
            if(StringUtils.isBlank(tenantAppId)){
                ConsumerCookieDTO consumerCookieDTO = AutoLoginUtil.getConsumerInfo();
                AssertUtil.isNotNull(consumerCookieDTO,ErrorCode.APP_ID_NOT_NULL);
                tenantAppId = String.valueOf(consumerCookieDTO.getAppId());
            }
            AssertUtil.isNotNull(tenantAppId,ErrorCode.APP_ID_NOT_NULL);

            Boolean verifyTenantAppOverdue = commonVerification.verifyTenantAppOverdue(Long.parseLong(tenantAppId));
            if (verifyTenantAppOverdue) {
                return Boolean.TRUE;
            } else {
                log.error("tenantApp:{} Overdue:{} ",tenantAppId,verifyTenantAppOverdue);
                throw new BizException(ErrorCode.TENANT_APP_OVERDUE.getMsg()).withCode(ErrorCode.TENANT_APP_OVERDUE.getCode());
            }

        }

        return Boolean.TRUE;
    }

    @Override
    public int getOrder() {
        return 10;
    }
}
