package cn.com.duiba.cloud.manage.sdk.handler;

import org.springframework.core.Ordered;

/**
 * 拦截器通用接口
 *
 * @author gyl
 * @version 1.0
 * @date 2022/5/24
 */
public interface ToCManageServiceHandler extends Ordered {

    /**
     * 拦截方法<br/>
     * 如果不允许访问，最好不返回false，直接抛出对应的BizException<br/>
     * 如果返回false，会在OpenApiInterceptor统一处理，返回errCode:-10，errorMsg:无权限访问<br/>
     *
     * @param handler handler
     * @return 是否放行 true/放行 false/拦截
     * @throws Exception 异常
     */
    Boolean accept(Object handler) throws Exception;

}
